HDISVAP1 ;BPFO/JRP - Application Programmer API(s);03/07/12  07:37
 ;;1.0;HEALTH DATA & INFORMATICS;**7**;Feb 22, 2005;Build 33
 ;
LABXCPT(ARRAY,TASKIT) ;Transmit Lab SNOMED CT exceptions
 ; Input: ARRAY - Array containing information about the exception
 ;              (FULL GLOBAL REFERENCE)
 ;          @ARRAY@(ETC, n) = Transaction number ^ Time stamp
 ;          @ARRAY@(ETC, n, [x, y, ...]) = Exception specific nodes
 ;
 ;            ETC is a code denoting the type of exception to report
 ;              1 = Load Exception
 ;              2 = Reference Lab
 ;              3 = Add/Edit by Site
 ;
 ;            Time Stamp is in FileMan format
 ;        TASKIT - Flag denoting if the work this API does should
 ;                 be queued to run
 ;                   1 = Queue to run
 ;                   0 = Run now (DEFAULT)
 ;
 ;Output: None
 ;      : The node @ARRAY@("XMZ") will be set equal to the message
 ;        number of the generated message.  A value of zero (0) will
 ;        be used when the message could not be generated.
 ;      : The node @ARRAY@("ZTSK") will be set equal to the task number
 ;        assigned if the TASKIT variable is set to one (1).  A value
 ;        of zero (0) will be used if queuing of this API's work was
 ;        not requested.
 ;      : The node @ARRAY@("ERROR", ETC) will be set equal to error
 ;        text for input exception type codes that are not supported.
 ;      : The node @ARRAY@("ERROR", ETC, n) will be set to error
 ;        text if the exception could not be handled.  This is
 ;        typically set because of a missing input node.  This node
 ;        will not be set for unsupported exception type codes.
 ;
 ; Notes: If this is not a production system the generated message
 ;        will be sent to the currently defined user (i.e. DUZ)
 ;      : The node @ARRAY@("ERROR") will be KILLed on input
 ;      : A pipe (|) is used as the delimiter for the "SA" and "SB"
 ;        nodes.  This is because they mirror the layout of the SNOMED
 ;        CT extract already implemented by the Lab package.
 ;      : A pipe (|) is used as the delimiter for the "RD" node.  This
 ;        is because it mirrors the layout of the resolution data being
 ;        transmitted by ERT to the Lab package for loading.
 ;      : The following text lists the nodes for each exception type
 ;
 ;   Exception Type Code 1: Load Exception
 ;   =====================================
 ;   @ARRAY@(1, n) = Transaction number ^ Time stamp
 ;   @ARRAY@(1, n, "TXT") = Text to describe why the exception was
 ;                          generated.  Contents is up to the
 ;                          discretion of the Lab package.
 ;   @ARRAY@(1, n, "SA") = The pipe delimited row of data for the
 ;                         entry that would be generated by the LR
 ;                         LAB SERVER when fulfilling a SNOMED extract
 ;                         report
 ;   @ARRAY@(1, n, "RD") = The pipe delimited row of data received
 ;                         from STS that the Lab package attempted
 ;                         to load
 ;
 ;   Exception Type Code 2: Reference Lab
 ;   ====================================
 ;   @ARRAY@(2, n) = Transaction number ^ Time stamp
 ;   @ARRAY@(2, n, "TXT") = Text to describe why the exception was
 ;                          generated.  Contents is up to the
 ;                          discretion of the Lab package.
 ;   @ARRAY@(2, n, "SA") = The pipe delimited row of data for the
 ;                         entry that would be generated by the LR
 ;                         LAB SERVER when fulfilling a SNOMED extract
 ;                         report
 ;   @ARRAY@(2, n, "RL") = Location type code ^ Location number ^
 ;                         Location name
 ;   @ARRAY@(2, n, "EC") = Encoding characters from HL-7 message
 ;   @ARRAY@(2, n, "OBX", 3) = Sequence 3 of received OBX segment
 ;   @ARRAY@(2, n, "OBX", 5) = Sequence 5 of received OBX segment
 ;
 ;     Location Type Code:
 ;       1 = DoD              4 = IHS 
 ;       2 = VA               5 = Other 
 ;       3 = Non-government   6 = Unknown
 ;
 ;   Exception Type Code 3: Add/Edit by Site
 ;   =======================================
 ;   @ARRAY@(3, n) = Transaction number ^ Time stamp
 ;   @ARRAY@(3, n, "TXT") = Text to describe why the exception was
 ;                          generated.  Contents is up to the
 ;                          discretion of the Lab package.
 ;   @ARRAY@(3, n, "SA") = The pipe delimited row of data for the
 ;                         entry that would be generated by the LR
 ;                         LAB SERVER when fulfilling a SNOMED extract
 ;                         report
 ;   @ARRAY@(3, n, "SB") = Same definition as the SA node except the
 ;                         values prior to the add/edit are used.
 ;                         Node not present for additions.
 ;
 ;
 ;   Alternate Array Format
 ;   ======================
 ;   Array nodes that are delimited pieces of data can also be broken
 ;   out into their individual pieces of data.  The only node that
 ;   CAN NOT be broken out in this manner is the main node for the
 ;   exception.
 ;   
 ;   Using exception type code 1 (Load Exception) as an example, the
 ;   alternate array format would be:
 ;
 ;     @ARRAY@(1, n) = Transaction number ^ Time stamp
 ;     @ARRAY@(1, n, "TXT") = Some kind of text
 ;     @ARRAY@(1, n, "SA", 1..N) = Piece N of the SA node
 ;     @ARRAY@(1, n, "RD", 1..N) = Piece N of the RD node
 ;
 ;   Note that the primary and alternate formats can not be used at
 ;   the same time for the same node.  If this is done, the data will
 ;   be ignored and the error node for the exception will be set.
 ;
 ;Initialize XMZ & ZTSK output nodes
 SET @ARRAY@("XMZ")=0
 SET @ARRAY@("ZTSK")=0
 SET TASKIT=+$GET(TASKIT)
 ;Queue running ?
 IF TASKIT DO  QUIT
 .;API asked to queue it's running
 .NEW ZTRTN,ZTDESC,ZTDTH,ZTIO,ZTSAVE,ZTSK,TMP
 .SET ZTRTN="TASKIT^HDISVAP1"
 .SET ZTDESC="Transmit Lab SNOMED CT exceptions"
 .SET ZTDTH=$HOROLOG
 .SET ZTIO=""
 .SET ZTSAVE("TASKIT")=1
 .KILL ^TMP("HDISVAP1-TASK",$JOB)
 .MERGE ^TMP("HDISVAP1-TASK",$JOB)=@ARRAY
 .SET ZTSAVE("ARRAY")="^TMP(""HDISVAP1-TASK"",$JOB)"
 .SET ZTSAVE("^TMP(""HDISVAP1-TASK"",$JOB,")=""
 .DO ^%ZTLOAD
 .KILL ^TMP("HDISVAP1-TASK",$JOB)
 .SET @ARRAY@("ZTSK")=$GET(ZTSK)
 .QUIT
TASKIT ;Entry point used when API is asked to queue itself
 NEW XMLDOC,SUMTXT,ENCODED,LINE,SUBJ,LOOP
 ;Initialize
 SET XMLDOC=$NAME(^TMP("HDISVAP1",$JOB,"XMLDOC"))
 SET SUMTXT=$NAME(^TMP("HDISVAP1",$JOB,"SUMTXT"))
 SET ENCODED=$NAME(^TMP("HDISVAP1",$JOB,"ENCODED"))
 KILL @XMLDOC,@SUMTXT,@ENCODED,@ARRAY@("ERROR")
 ;Build XML document & summary text - quit if nothing to encode/send
 IF ('$$BUILD^HDISVAP2(ARRAY,XMLDOC,SUMTXT)) DO  QUIT
 .KILL @XMLDOC,@SUMTXT,@ENCODED
 .QUIT
 ;UUEncode array containing XML document
 SET @XMLDOC@(0)=$$FILENAME^HDISVAP3()
 DO ENCODE^HDISVM03(XMLDOC,ENCODED,1)
 ;Combine UUEncoded array and summary text
 SET LINE=0
 FOR  SET LINE=+$ORDER(@SUMTXT@(LINE)) QUIT:('LINE)  DO
 .SET @ENCODED@(LINE*.000001)=@SUMTXT@(LINE,0)
 ;Build & send message
 SET SUBJ="Lab Exception(s): "_$GET(@SUMTXT@(0))
 IF ($LENGTH(SUBJ)>64) DO
 .FOR LOOP=$LENGTH(SUBJ,","):-1 DO   QUIT:($LENGTH(SUBJ)<59)
 ..SET SUBJ=$PIECE(SUBJ,",",1,LOOP-1)
 .SET SUBJ=SUBJ_", ..."
 SET @ARRAY@("XMZ")=$$SENDMSG^HDISVAP3(ENCODED,SUBJ)
 ;Clean up
 KILL @XMLDOC,@SUMTXT,@ENCODED
 ;Checked for tasked use
 IF $DATA(ZTQUEUED) DO
 .;Delete task & input/output array
 .SET ZTREQ="@"
 .KILL @ARRAY
 .QUIT
 QUIT
